/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201.mixin.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import mcinterface1201.BuilderEntityExisting;
import mcinterface1201.BuilderEntityLinkedSeat;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    private Vec3 pVec;

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getEyePosition(float pPartialTicks, CallbackInfoReturnable<Vec3> ci) {
        Entity entity = (Entity)this;
        Entity riding = entity.m_20202_();
        if (riding instanceof BuilderEntityLinkedSeat) {
            BuilderEntityLinkedSeat builder = (BuilderEntityLinkedSeat)riding;
            if (builder.entity != null) {
                ci.setReturnValue((Object)new Vec3(builder.entity.riderHeadPosition.x, builder.entity.riderHeadPosition.y, builder.entity.riderHeadPosition.z));
            }
        }
    }

    @Inject(method={"collide"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntityCollisions(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;")})
    private void inject_collide(Vec3 pVec, CallbackInfoReturnable<Vec3> ci) {
        this.pVec = pVec;
    }

    @ModifyVariable(method={"collide"}, at=@At(value="STORE"), name={"list"})
    private List<VoxelShape> modify_collidelist(List<VoxelShape> existingCollisions) {
        Entity entity = (Entity)this;
        AABB pCollisionBox = entity.m_20191_().m_82369_(this.pVec);
        ArrayList<VoxelShape> vehicleCollisions = null;
        for (BuilderEntityExisting builder : entity.m_9236_().m_45976_(BuilderEntityExisting.class, pCollisionBox)) {
            if (builder.collisionBoxes == null || !builder.collisionBoxes.m_82381_(pCollisionBox)) continue;
            for (BoundingBox box : builder.collisionBoxes.getBoxes()) {
                AABB convertedBox = WrapperWorld.convert(box);
                if (!convertedBox.m_82381_(pCollisionBox)) continue;
                if (vehicleCollisions == null) {
                    vehicleCollisions = new ArrayList<VoxelShape>();
                }
                vehicleCollisions.add(Shapes.m_83064_((AABB)convertedBox));
            }
        }
        if (vehicleCollisions != null) {
            if (!existingCollisions.isEmpty()) {
                BuilderEntityExisting builder;
                List oldImmutableList = entity.m_9236_().m_183134_(entity, pCollisionBox);
                builder = ImmutableList.builderWithExpectedSize((int)(oldImmutableList.size() + vehicleCollisions.size()));
                builder.addAll(oldImmutableList);
                builder.addAll(vehicleCollisions);
                return builder.build();
            }
            return vehicleCollisions;
        }
        return existingCollisions;
    }
}

